%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Generating a distortion correction function for the Galen
%% Robot and apply it to distorted data K
%% Can Kocabalkanli and Nicolas Lamaison; Programming Assignment 2; CIS 2, Fall 2019

function [S, qmax, qmin, C_cor_2D] = correct3D(C_data_2D, C_exp_2D)
    
% Get coefficients for distortion correction
S = get_coeffs(C_exp_2D, C_data_2D);

% Define C_cor_2D
C_cor_2D = zeros(size(C_data_2D, 1), 3);

% Get q, qmax, qmin
qmax = [max(C_data_2D(:,1)) ; max(C_data_2D(:,2)) ; max(C_data_2D(:,3))]; %order reverse because of the way we defined P and Q
qmin = [min(C_data_2D(:,1)) ; min(C_data_2D(:,2)) ; min(C_data_2D(:,3))];

% Use correction distortion function to get corrected C values
for i = 1:size(C_data_2D, 1)
    
    % Select current marker, compute corrected position vector, and compile
    % corrected vectors into a matrix
    q = C_data_2D(i, :);
    p = correctDistortion(q, qmax, qmin, S);
    C_cor_2D(i, :) = p;

end

end